package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO of a related node (parent/child) of institutional page.
 */
@Schema(
        name = "OutputRelatedInstitutionalPageDto",
        description = "Output DTO of a related node (parent/child) of institutional page"
)
@Data
@Builder
@AllArgsConstructor
public class OutputRelatedInstitutionalPageDto {

    @Schema(description = "ID of the related institutional page", example = "11111111-bbbb-0000-0000-000000000000")
    private UUID institutionalPageId;

    @Schema(description = "Name of the related institutional page", example = "WP3 T-Res")
    private String institutionalPageName;

    @Schema(description = "ID of the related workspace folder", example = "22222222-bbbb-0000-0000-000000000000")
    private UUID workspaceFolderId;

    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    private String category;

    @Schema(
            description = "Indicates whether the logged user is member of the related institutional page",
            example = "true"
    )
    private Boolean isMember;

}
