package com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageForMembersInHierarchyIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InviteMembersIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.MembersInHierarchyIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPInvitationRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestsIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.RemoveMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.SubmitJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageForMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.UserProfileRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Component
@RequiredArgsConstructor
public class MemberMapper {
    private final InstitutionalPageMapper institutionalPageMapper;
    private final MemberPartialMapper partialMapper;
    private final UserProfileRepository userProfileRepository;

    public InviteMembersIPDmDto toInviteMembersIPDmDto(InputInviteMembersDto dto) {
        return partialMapper.toInviteMembersIPDmDto(dto);
    }

    public SubmitJoinRequestIPDmDto toSubmitJoinRequestIPDmDto(InputSubmitJoinRequestDto dto) {
        return partialMapper.toSubmitJoinRequestIPDmDto(dto);
    }

    public PatchIPInvitationRequestIPDmDto toPatchIPInvitationRequestIPDmDto(InputPatchIPInvitationRequestDto dto) {
        return partialMapper.toPatchIPInvitationRequestIPDmDto(dto);
    }

    public PatchIPJoinRequestIPDmDto toPatchIPJoinRequestIPDmDto(InputPatchIPJoinRequestDto dto) {
        return partialMapper.toPatchIPJoinRequestIPDmDto(dto);
    }

    public PatchMembershipIPDmDto toPatchMembershipIPDmDto(InputPatchMembershipDto dto) {
        return partialMapper.toPatchMembershipIPDmDto(dto);
    }

    public RemoveMembershipIPDmDto toRemoveMembershipIPDmDto(InputRemoveMembershipDto dto) {
        return partialMapper.toRemoveMembershipIPDmDto(dto);
    }

    public OutputPendingMemberRequestsDto toOutputPendingMemberRequestsDto(PendingMemberRequestsIPDmDto dto) {
        List<OutputPendingMemberRequestDto> joinRequests = dto.getJoinRequests().stream()
                .map(this::toOutputPendingMemberRequestDto)
                .toList();

        List<OutputPendingMemberRequestDto> invitations = dto.getInvitations().stream()
                .map(this::toOutputPendingMemberRequestDto)
                .toList();

        return OutputPendingMemberRequestsDto.builder()
                .joinRequests(joinRequests)
                .invitations(invitations)
                .build();
    }

    public OutputPendingMemberRequestDto toOutputPendingMemberRequestDto(PendingMemberRequestIPDmDto dto) {
        OutputPendingMemberRequestDto outputPendingMemberRequestDto =
                partialMapper.toOutputPendingMemberRequestDto(dto);

        UUID userId = dto.getUserId();
        OutputUserProfileDto userProfileDto =
                userProfileRepository.getMemberProfilesOrThrow(List.of(userId)).getFirst();
        outputPendingMemberRequestDto.setUser(userProfileDto);

        outputPendingMemberRequestDto.setInstitutionalPage(
                institutionalPageMapper.toOutputInstitutionalPageDto(dto.getInstitutionalPage(), true)
        );

        return outputPendingMemberRequestDto;
    }

    public OutputPageDto<OutputMembersInHierarchyDto> toOutputMembersInHierarchyDto(OutputPageDto<MembersInHierarchyIPDmDto> dto) {
        List<OutputMembersInHierarchyDto> outputMembersInHierarchyDtoList = new ArrayList<>();
        dto.getContent().forEach(membersInHierarchyIPDmDto -> {
            // Do the partial mapping
            OutputMembersInHierarchyDto outputMembersInHierarchyDto =
                    partialMapper.toOutputMembersInHierarchyDto(membersInHierarchyIPDmDto);

            // Retrieve the user profile of the user id
            UUID userId = membersInHierarchyIPDmDto.getUserId();
            OutputUserProfileDto userProfileDto =
                    userProfileRepository.getMemberProfilesOrThrow(List.of(userId)).getFirst();

            // Set the user and map rootInstitutionalPage and other institutional pages
            outputMembersInHierarchyDto.setUser(userProfileDto);
            outputMembersInHierarchyDto.setInstitutionalPages(
                    toOutputInstitutionalPageForMembersInHierarchyDto(membersInHierarchyIPDmDto.getInstitutionalPages())
            );
            outputMembersInHierarchyDto.setRootInstitutionalPage(
                    institutionalPageMapper.toOutputInstitutionalPageDto(membersInHierarchyIPDmDto.getRootInstitutionalPage(), true)
            );

            outputMembersInHierarchyDtoList.add(outputMembersInHierarchyDto);
        });

        return OutputPageDto.<OutputMembersInHierarchyDto>builder()
                .page(dto.getPage())
                .content(outputMembersInHierarchyDtoList)
                .build();
    }

    public List<OutputInstitutionalPageForMembersInHierarchyDto> toOutputInstitutionalPageForMembersInHierarchyDto(List<InstitutionalPageForMembersInHierarchyIPDmDto> dto) {
        List<OutputInstitutionalPageForMembersInHierarchyDto> outputInstitutionalPageForMembersInHierarchyDtoList = new ArrayList<>();
        dto.forEach(institutionalPageForMembersInHierarchyIPDmDto -> {
            OutputInstitutionalPageForMembersInHierarchyDto outputInstitutionalPageForMembersInHierarchyDto =
                    partialMapper.toOutputInstitutionalPageForMembersInHierarchyDto(institutionalPageForMembersInHierarchyIPDmDto);

            outputInstitutionalPageForMembersInHierarchyDto.setInstitutionalPage(
                institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageForMembersInHierarchyIPDmDto.getInstitutionalPage(), true)
            );

            outputInstitutionalPageForMembersInHierarchyDtoList.add(outputInstitutionalPageForMembersInHierarchyDto);
        });

        return outputInstitutionalPageForMembersInHierarchyDtoList;
    }
}
