package com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageForMembersInHierarchyIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InviteMembersIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.MembersInHierarchyIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPInvitationRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchIPJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PatchMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.PendingMemberRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.RemoveMembershipIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.SubmitJoinRequestIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageForMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPendingMemberRequestDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface MemberPartialMapper {
    InviteMembersIPDmDto toInviteMembersIPDmDto(InputInviteMembersDto dto);
    SubmitJoinRequestIPDmDto toSubmitJoinRequestIPDmDto(InputSubmitJoinRequestDto dto);

    PatchIPInvitationRequestIPDmDto toPatchIPInvitationRequestIPDmDto(InputPatchIPInvitationRequestDto dto);
    PatchIPJoinRequestIPDmDto toPatchIPJoinRequestIPDmDto(InputPatchIPJoinRequestDto dto);
    PatchMembershipIPDmDto toPatchMembershipIPDmDto(InputPatchMembershipDto dto);
    RemoveMembershipIPDmDto toRemoveMembershipIPDmDto(InputRemoveMembershipDto dto);

    @Mapping(target = "user", ignore = true)
    @Mapping(target = "institutionalPage", ignore = true)
    OutputPendingMemberRequestDto toOutputPendingMemberRequestDto(PendingMemberRequestIPDmDto dto);

    @Mapping(target = "user", ignore = true)
    @Mapping(target = "rootInstitutionalPage", ignore = true)
    OutputMembersInHierarchyDto toOutputMembersInHierarchyDto(MembersInHierarchyIPDmDto dto);

    @Mapping(target = "institutionalPage", ignore = true)
    OutputInstitutionalPageForMembersInHierarchyDto toOutputInstitutionalPageForMembersInHierarchyDto(InstitutionalPageForMembersInHierarchyIPDmDto dto);
}