package com.finconsgroup.itserr.marketplace.institutional_page.bs.service;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;

import java.util.Set;
import java.util.UUID;

public interface PublishedInstitutionalPageService {

    /**
     * Get all published institutional pages for which the user is a contributor
     *
     * @param associationsToLoad the associations to be returned on the response
     * @param pageNumber the number of the page
     * @param pageSize the size of the page
     * @param sort the attribute to sort by
     * @param direction the direction of sorting
     * @param withPublications flag indicating whether to include the publication information in the response
     * @return the institutional page
     */
    OutputPageDto<OutputInstitutionalPageDto> getAllPublishedInstitutionalPages(
            Set<String> associationsToLoad,
            int pageNumber,
            int pageSize,
            String sort,
            SortDirection direction,
            boolean withPublications
    );

    /**
     * Get a published institutional page by id
     *
     * @param institutionalPageId the id of the institutional page
     * @param withPublications flag indicating whether to include the publication information in the response
     * @return the institutional page
     */
    OutputInstitutionalPageDto getPublishedInstitutionalPageById(UUID institutionalPageId, boolean withPublications);

    /**
     * Retrieves a paginated list of all published InstitutionalPages matching the search criteria.
     *
     * @param inputSearchInstitutionalPageDto the input DTO containing search criteria
     * @param associationsToLoad the associations to be returned on the response
     * @param pageNumber                      the number of the page
     * @param pageSize                        the size of the page
     * @param sort                            the attribute to sort by
     * @param direction                       the direction of sorting
     * @param withPublications flag indicating whether to include the publication information in the response
     * @return a page of OutputInstitutionalPageDto representing the InstitutionalPages
     */
    OutputPageDto<OutputInstitutionalPageDto> search(
            InputSearchPublishedInstitutionalPageDto inputSearchInstitutionalPageDto,
            Set<String> associationsToLoad,
            int pageNumber,
            int pageSize,
            String sort,
            SortDirection direction,
            boolean withPublications
    );
}
