/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedMemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="archived_member_request")
public class ArchivedMemberRequestEntity
extends AbstractUUIDEntity {
    @Column(name="user_id", nullable=false)
    private UUID userId;
    @Column(name="institutional_page_id", nullable=false)
    private UUID institutionalPageId;
    @Column(name="request_type", nullable=false)
    private MemberRequestType requestType;
    @Column(name="wp_leader", nullable=false)
    private boolean wpLeader;
    @Column(name="message")
    private String message;
    @Column(name="request_status", nullable=false)
    private MemberRequestStatus requestStatus;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false, updatable=false)
    private Instant updateTime;
    @Column(name="archival_time", nullable=false, updatable=false)
    private Instant archivalTime;

    @PrePersist
    public void onCreate() {
        this.archivalTime = Instant.now().truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected ArchivedMemberRequestEntity(ArchivedMemberRequestEntityBuilder<?, ?> b) {
        super(b);
        this.userId = b.userId;
        this.institutionalPageId = b.institutionalPageId;
        this.requestType = b.requestType;
        this.wpLeader = b.wpLeader;
        this.message = b.message;
        this.requestStatus = b.requestStatus;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.archivalTime = b.archivalTime;
    }

    @Generated
    public static ArchivedMemberRequestEntityBuilder<?, ?> builder() {
        return new ArchivedMemberRequestEntityBuilderImpl();
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public UUID getInstitutionalPageId() {
        return this.institutionalPageId;
    }

    @Generated
    public MemberRequestType getRequestType() {
        return this.requestType;
    }

    @Generated
    public boolean isWpLeader() {
        return this.wpLeader;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public MemberRequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Instant getArchivalTime() {
        return this.archivalTime;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setInstitutionalPageId(UUID institutionalPageId) {
        this.institutionalPageId = institutionalPageId;
    }

    @Generated
    public void setRequestType(MemberRequestType requestType) {
        this.requestType = requestType;
    }

    @Generated
    public void setWpLeader(boolean wpLeader) {
        this.wpLeader = wpLeader;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setRequestStatus(MemberRequestStatus requestStatus) {
        this.requestStatus = requestStatus;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setArchivalTime(Instant archivalTime) {
        this.archivalTime = archivalTime;
    }

    @Generated
    public String toString() {
        return "ArchivedMemberRequestEntity(userId=" + String.valueOf(this.getUserId()) + ", institutionalPageId=" + String.valueOf(this.getInstitutionalPageId()) + ", requestType=" + String.valueOf(this.getRequestType()) + ", wpLeader=" + this.isWpLeader() + ", message=" + this.getMessage() + ", requestStatus=" + String.valueOf(this.getRequestStatus()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", archivalTime=" + String.valueOf(this.getArchivalTime()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedMemberRequestEntity)) {
            return false;
        }
        ArchivedMemberRequestEntity other = (ArchivedMemberRequestEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isWpLeader() != other.isWpLeader()) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        UUID this$institutionalPageId = this.getInstitutionalPageId();
        UUID other$institutionalPageId = other.getInstitutionalPageId();
        if (this$institutionalPageId == null ? other$institutionalPageId != null : !((Object)this$institutionalPageId).equals(other$institutionalPageId)) {
            return false;
        }
        MemberRequestType this$requestType = this.getRequestType();
        MemberRequestType other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        MemberRequestStatus this$requestStatus = this.getRequestStatus();
        MemberRequestStatus other$requestStatus = other.getRequestStatus();
        if (this$requestStatus == null ? other$requestStatus != null : !this$requestStatus.equals(other$requestStatus)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Instant this$archivalTime = this.getArchivalTime();
        Instant other$archivalTime = other.getArchivalTime();
        return !(this$archivalTime == null ? other$archivalTime != null : !((Object)this$archivalTime).equals(other$archivalTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedMemberRequestEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isWpLeader() ? 79 : 97);
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        UUID $institutionalPageId = this.getInstitutionalPageId();
        result = result * 59 + ($institutionalPageId == null ? 43 : ((Object)$institutionalPageId).hashCode());
        MemberRequestType $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        MemberRequestStatus $requestStatus = this.getRequestStatus();
        result = result * 59 + ($requestStatus == null ? 43 : $requestStatus.hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Instant $archivalTime = this.getArchivalTime();
        result = result * 59 + ($archivalTime == null ? 43 : ((Object)$archivalTime).hashCode());
        return result;
    }

    @Generated
    public ArchivedMemberRequestEntity() {
    }
}

