/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MemberRequestRepository
extends JpaRepository<MemberRequestEntity, UUID> {
    public List<MemberRequestEntity> findAllByInstitutionalPageIdIn(Set<UUID> var1);

    public void deleteAllByInstitutionalPageId(UUID var1);

    public List<MemberRequestEntity> findAllByUserId(UUID var1);

    public List<MemberRequestEntity> findAllByInstitutionalPageIdAndUserIdIn(UUID var1, List<UUID> var2);

    public List<MemberRequestEntity> findAllByInstitutionalPageIdAndUserIdInAndRequestType(UUID var1, List<UUID> var2, MemberRequestType var3);

    public Optional<MemberRequestEntity> findByInstitutionalPageIdAndUserIdAndRequestType(UUID var1, UUID var2, MemberRequestType var3);

    @Query(value="select request.*\nfrom member_request request\njoin institutional_page ip\n    on request.institutional_page_id = ip.id\nwhere\n    request.user_id in (:userIds)\n    and coalesce(ip.ancestor_institutional_page_ids[1], ip.id) = :rootInstitutionalPageId\n", nativeQuery=true)
    public List<MemberRequestEntity> findAllRequestsFromIpAndDescendants(@Param(value="rootInstitutionalPageId") UUID var1, @Param(value="userIds") List<UUID> var2);
}

