/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputInternalFindMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.ArchivedMetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import com.finconsgroup.itserr.marketplace.metadata.dm.exception.MetadataExistsException;
import com.finconsgroup.itserr.marketplace.metadata.dm.exception.MetadataNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.dm.mapper.ArchivedMetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.dm.mapper.MetadataFieldMapper;
import com.finconsgroup.itserr.marketplace.metadata.dm.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.ArchivedMetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataFieldRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.specification.MetadataSpecifications;
import com.finconsgroup.itserr.marketplace.metadata.dm.service.MetadataService;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultMetadataService
implements MetadataService {
    private final MetadataRepository metadataRepository;
    private final MetadataFieldRepository metadataFieldRepository;
    private final ArchivedMetadataRepository archivedMetadataRepository;
    private final MetadataMapper metadataMapper;
    private final MetadataFieldMapper metadataFieldMapper;
    private final ArchivedMetadataMapper archivedMetadataMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputMetadataPreviewDto> findAll(MetadataCategoryEnum metadataCategoryEnum, @NonNull Pageable pageable) {
        if (metadataCategoryEnum != null) {
            return this.metadataRepository.findAllByCategory(metadataCategoryEnum, pageable).map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataPreviewDto(arg_0));
        }
        return this.metadataRepository.findAll(pageable).map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataPreviewDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputMetadataFieldDto> findAllFieldsById(UUID metadataId, @NonNull Pageable pageable) {
        return this.metadataFieldRepository.findAllByMetadataId(metadataId, pageable).map(arg_0 -> ((MetadataFieldMapper)this.metadataFieldMapper).metadataFieldEntityToMetadataFieldDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputMetadataFieldExtDto> findAllFields(MetadataCategoryEnum category, @NonNull Pageable pageable) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Page metadataCategories = category != null ? (category.equals((Object)MetadataCategoryEnum.PERSONAL) ? this.metadataFieldRepository.findByCategoryInAndCreatorId(List.of(category), userId, pageable) : this.metadataFieldRepository.findByMetadataCategory(category, pageable)) : this.metadataFieldRepository.findByCategoryInOrCreatorId(List.of(MetadataCategoryEnum.COMMUNITY, MetadataCategoryEnum.STANDARD), userId, pageable);
        return metadataCategories.map(arg_0 -> ((MetadataFieldMapper)this.metadataFieldMapper).metadataFieldEntityToMetadataFieldExtDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputMetadataDto findById(@NonNull UUID metadataId) {
        return this.metadataRepository.findById((Object)metadataId).map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataDto(arg_0)).orElseThrow(() -> new MetadataNotFoundException(metadataId));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputMetadataDto create(@NonNull InputCreateMetadataDto request, @NonNull UUID userId) {
        String name = StringUtils.trim((String)request.getName());
        if (this.metadataRepository.countByNameIgnoreCase(name) > 0) {
            throw new MetadataExistsException(name);
        }
        MetadataEntity metadata = this.metadataMapper.metadataSaveRequestDtoToMetadataEntity(request, userId);
        MetadataEntity savedMetadata = (MetadataEntity)this.metadataRepository.saveAndFlush((Object)metadata);
        return this.metadataMapper.metadataEntityToMetadataDto(savedMetadata);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, noRollbackFor={Exception.class}, readOnly=true)
    public List<OutputMetadataDto> find(@Nullable InputInternalFindMetadataDto request) {
        List foundMetadata = request == null ? this.metadataRepository.findAll() : this.metadataRepository.findAll(MetadataSpecifications.ids((Collection)request.getId()));
        return foundMetadata.stream().map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataDto(arg_0)).toList();
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputMetadataDto deleteById(@NonNull UUID metadataId) {
        MetadataEntity metadataEntity = (MetadataEntity)this.metadataRepository.findById((Object)metadataId).orElseThrow(() -> new MetadataNotFoundException(metadataId));
        ArchivedMetadataEntity archivedMetadataEntity = this.archivedMetadataMapper.metadataEntityToArchivedMetadataEntity(metadataEntity);
        this.archivedMetadataRepository.save((Object)archivedMetadataEntity);
        this.metadataRepository.delete((Object)metadataEntity);
        return this.metadataMapper.metadataEntityToMetadataDto(metadataEntity);
    }

    @Generated
    public DefaultMetadataService(MetadataRepository metadataRepository, MetadataFieldRepository metadataFieldRepository, ArchivedMetadataRepository archivedMetadataRepository, MetadataMapper metadataMapper, MetadataFieldMapper metadataFieldMapper, ArchivedMetadataMapper archivedMetadataMapper) {
        this.metadataRepository = metadataRepository;
        this.metadataFieldRepository = metadataFieldRepository;
        this.archivedMetadataRepository = archivedMetadataRepository;
        this.metadataMapper = metadataMapper;
        this.metadataFieldMapper = metadataFieldMapper;
        this.archivedMetadataMapper = archivedMetadataMapper;
    }
}

