package com.finconsgroup.itserr.marketplace.metadata.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.Singular;

import java.util.List;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;

/**
 * Metadata create request DTO.
 */
@Schema(
        name = "MetadataCreateRequest",
        description = "Metadata creation request"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InputCreateMetadataDto {

    /**
     * Name field length.
     */
    public static final int NAME_LENGTH = 50;

    /**
     * Description field length.
     */
    public static final int DESCRIPTION_LENGTH = 2000;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    @NotBlank
    @Size(max = NAME_LENGTH)
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    @Size(max = DESCRIPTION_LENGTH)
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryEnum category;

    @Schema(description = "Metadata fields")
    @NotEmpty
    @Valid
    @Singular
    private List<InputCreateMetadataFieldDto> fields;

}
