package com.finconsgroup.itserr.marketplace.metadata.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.UUID;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;

/**
 * Metadata DTO.
 */
@Schema(
        name = "Metadata Minimal",
        description = "Represents a metadata"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataMinimalDto {

    /**
     * Name field length.
     */
    public static final int NAME_LENGTH = 50;

    /**
     * Description field length.
     */
    public static final int DESCRIPTION_LENGTH = 2000;

    @Schema(
            description = "Metadata id",
            example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID id;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryEnum category;

    @Schema(description = "The ID of the creator", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;


}
