package com.finconsgroup.itserr.marketplace.metadata.dm.mapper;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.ArchivedMetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.ArchivedMetadataFieldEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataFieldEntity;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

/**
 * Archived Metadata related mapper.
 */
@Mapper(config = MapperConfiguration.class)
public interface ArchivedMetadataMapper {

    /**
     * Maps a {@link MetadataEntity} into a {@link ArchivedMetadataEntity}.
     * @param src Source request.
     * @return Mapped entity.
     */
    ArchivedMetadataEntity metadataEntityToArchivedMetadataEntity(MetadataEntity src);

    /**
     * Maps a {@link MetadataFieldEntity} into a {@link ArchivedMetadataFieldEntity}
     * ignore the metadata field inside metadata archive
     * @param src Source entity.
     * @return Mapped dto.
     */
    @Mapping(target = "metadata", ignore = true)
    ArchivedMetadataFieldEntity metadataFieldEntityToArchivedMetadataFieldEntity(MetadataFieldEntity src);

    /**
     * After mapping into a {@link ArchivedMetadataEntity},
     * ensures that each of its fields has reference to the owning archivedMetadataEntity.
     * @param archivedMetadataEntity Mapped {@link ArchivedMetadataEntity}.
     */
    @AfterMapping
    default void setFieldsMetadataReference(@MappingTarget ArchivedMetadataEntity archivedMetadataEntity) {
        if (archivedMetadataEntity != null && archivedMetadataEntity.getFields() != null) {
            archivedMetadataEntity.getFields().forEach(field -> field.setMetadata(archivedMetadataEntity));
        }
    }

}
