package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output DTO for creating a metric event beneficiary.
 */
@Schema(name = "OutputBeneficiary", description = "DTO for creating a metric event beneficiary")
@Data
@Builder
@AllArgsConstructor
public class OutputBeneficiaryDto {

    @Schema(description = "The beneficiary user, expressed as an id or a mail", examples = { "123e4567-e89b-12d3-a456-426614174000", "user@mail.mail" })
    private String user;

}
