package com.finconsgroup.itserr.marketplace.metrics.dm.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.UUID;

/**
 * Entity class representing a metric event beneficiary.
 */
@Entity
@Table(name = "metric_event_beneficiary")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@IdClass(MetricEventBeneficiaryEntity.MetricEventBeneficiaryId.class)
public class MetricEventBeneficiaryEntity {

    /**
     * Composite ID of the {@link MetricEventBeneficiaryEntity}.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor(staticName = "of")
    public static class MetricEventBeneficiaryId implements Serializable {

        /** The metric name that identifies the type of event */
        private MetricType metric;

        /** The UUID of the metric event */
        private UUID eventId;

        /** The beneficiary user reference (uuid or mail) */
        private String userRef;

    }

    /**
     * The name of the metric.
     */
    @Id
    @Enumerated(EnumType.STRING)
    @Column(name = "metric", nullable = false)
    private MetricType metric;

    /** The UUID of the metric event */
    @Id
    @Column(name = "event_id", nullable = false)
    private UUID eventId;

    /** The beneficiary user */
    @Id
    @Column(name = "user_ref", nullable = false)
    private String userRef;

}
