/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.ParagraphMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ParagraphMapperImpl
implements ParagraphMapper {
    public ParagraphEntity toEntity(InputParagraphDto model) {
        if (model == null) {
            return null;
        }
        ParagraphEntity.ParagraphEntityBuilder paragraphEntity = ParagraphEntity.builder();
        paragraphEntity.title(model.getTitle());
        paragraphEntity.content(model.getContent());
        paragraphEntity.imageUrl(model.getImageUrl());
        paragraphEntity.resourceUrl(model.getResourceUrl());
        List list = model.getLabels();
        if (list != null) {
            paragraphEntity.labels(new ArrayList(list));
        }
        return paragraphEntity.build();
    }

    public OutputParagraphDto toDto(ParagraphEntity entity) {
        if (entity == null) {
            return null;
        }
        OutputParagraphDto.OutputParagraphDtoBuilder outputParagraphDto = OutputParagraphDto.builder();
        outputParagraphDto.id(entity.getId());
        outputParagraphDto.title(entity.getTitle());
        outputParagraphDto.content(entity.getContent());
        outputParagraphDto.imageUrl(entity.getImageUrl());
        outputParagraphDto.resourceUrl(entity.getResourceUrl());
        List list = entity.getLabels();
        if (list != null) {
            outputParagraphDto.labels(new ArrayList(list));
        }
        return outputParagraphDto.build();
    }

    public void updateEntity(ParagraphEntity entity, InputParagraphDto inputParagraphDto) {
        if (inputParagraphDto == null) {
            return;
        }
        entity.setTitle(inputParagraphDto.getTitle());
        entity.setContent(inputParagraphDto.getContent());
        entity.setImageUrl(inputParagraphDto.getImageUrl());
        entity.setResourceUrl(inputParagraphDto.getResourceUrl());
        if (entity.getLabels() != null) {
            List list = inputParagraphDto.getLabels();
            if (list != null) {
                entity.getLabels().clear();
                entity.getLabels().addAll(list);
            } else {
                entity.setLabels(null);
            }
        } else {
            List list = inputParagraphDto.getLabels();
            if (list != null) {
                entity.setLabels(new ArrayList(list));
            }
        }
    }

    public List<ParagraphEntity> cloneParagraphList(List<ParagraphEntity> src) {
        if (src == null) {
            return null;
        }
        ArrayList<ParagraphEntity> list = new ArrayList<ParagraphEntity>(src.size());
        for (ParagraphEntity paragraphEntity : src) {
            list.add(this.cloneParagraph(paragraphEntity));
        }
        return list;
    }

    public List<ParagraphEntity> inputParagraphListToParagraphEntityList(List<InputParagraphDto> src) {
        if (src == null) {
            return null;
        }
        ArrayList<ParagraphEntity> list = new ArrayList<ParagraphEntity>(src.size());
        for (InputParagraphDto inputParagraphDto : src) {
            list.add(this.toEntity(inputParagraphDto));
        }
        return list;
    }

    public ParagraphEntity cloneParagraph(ParagraphEntity paragraph) {
        if (paragraph == null) {
            return null;
        }
        ParagraphEntity.ParagraphEntityBuilder paragraphEntity = ParagraphEntity.builder();
        paragraphEntity.institutionalPageId(paragraph.getInstitutionalPageId());
        paragraphEntity.title(paragraph.getTitle());
        paragraphEntity.content(paragraph.getContent());
        paragraphEntity.imageUrl(paragraph.getImageUrl());
        paragraphEntity.resourceUrl(paragraph.getResourceUrl());
        List list = paragraph.getLabels();
        if (list != null) {
            paragraphEntity.labels(new ArrayList(list));
        }
        paragraphEntity.creationTime(paragraph.getCreationTime());
        paragraphEntity.updateTime(paragraph.getUpdateTime());
        return paragraphEntity.build();
    }
}

